/****************************************************************************
* Donohue and Wolfers (2006) 
* Figure 6
* Homicides Before and After the Texas Stay
****************************************************************************/


clear
cd "..."
use "Texas.dta", clear

gen event=( dt>=start & dt<=end )
list dt if event==1
reg lntxsa lnustxsa if year<1996
predict txhat if year>=1996
replace txhat=exp(txhat)
twoway (line txsa dt, sort lcolor(red)) (line ustxsa dt, yaxis(2) sort lcolor(navy)) (line txhat dt, lcolor(green) lpattern(dash)), ytitle(Monthly homicide count in Texas ) ylabel(0(50)250, angle(horizontal)) xtitle("") xlabel( 10593 10958 11323 11688 12054 12419 12784 13149 13515 13880, angle(forty_five) format(%dm_cY)) xline(13240 13605, lcolor(black)) ytitle("Monthly homicide count in the US (excluding Texas)", axis(2)) ylabel(0(400)2000, angle(horizontal) axis(2)) title("Homicide Before and After the Texas Stay") subtitle("Texas ceased scheduling executions from April 1996 to April 1997") note("Monthly data January 1989-December 1997, seasonally adjusted using X-12.") legend(rows(3) order(1 "Texas (left axis)" 3 "US less Texas (right axis)" 2 "Projected homicides in Texas" "Estimated 1989-1995:  ln(Texas) =-4.1 + 1.27*ln(US less TX)")) legend(position(7) ring(0) region(fcolor(none) lcolor(none))) xsize(10) ysize(7.5)
gen diff=txsa-txhat
reg lntxsa lnustxsa event
twoway (line txsa dt, sort lcolor(red)) (line ustxsa dt, yaxis(2) sort lcolor(navy)) (line txhat dt, lcolor(green) lpattern(dash)) (bar diff dt, barwidth(30)), ytitle(Monthly homicide count in Texas ) ylabel(0(50)250 -50 " ", angle(horizontal)) xtitle("") xlabel( 10593 10958 11323 11688 12054 12419 12784 13149 13515 13880, angle(forty_five) format(%dm_cY)) xline(13240 13605, lcolor(black)) ytitle("Monthly homicide count in the US (excluding Texas)", axis(2)) ylabel(0(400)2000 -400 " ", angle(horizontal) axis(2)) title("Homicide Before and After the Texas Stay") subtitle("Texas ceased scheduling executions from April 1996 to April 1997") note("Monthly data January 1989-December 1997, seasonally adjusted using X-12.") legend(rows(4) order(1 "Texas (left axis)" 4 "US less Texas (right axis)" 2 "Projected homicides in Texas" "Estimated 1989-1995:" "ln(Texas) =-4.1 + 1.27*ln(US less TX)" 3 "Texas: Actual homicides less predicted")) legend(position(7) ring(0) region(fcolor(none) lcolor(none)))
